#include <iostream>
#include <QKeyEvent>
#include <QLabel>
#include <QGridLayout>
#include <QWidget>
#include <QDialog>
#include <QMainWindow>
#include <QApplication>
/**********************************************************/

class Dialog  : public QDialog
{
    //Q_OBJECT
public:
    Dialog(QWidget *parent = nullptr);
private:
    QLabel *qb1;
};

Dialog::Dialog(QWidget *parent) : QDialog(parent) {
    resize(400,200);
    QGridLayout grid(this);
    qb1 = new QLabel(tr("click on this label"), this);
    grid.addWidget(qb1);
}
/**********************************************************/

class MainWindow : public QMainWindow
{
   // Q_OBJECT
public:
    MainWindow(QWidget *parent = nullptr);
    ~MainWindow();
    void keyPressEvent(QKeyEvent *e);
private:
    Dialog * dbox;
    QCursor brushCursor;
    QCursor eraseCursor;
};

MainWindow::MainWindow(QWidget *parent) : QMainWindow(parent) {
    dbox = new Dialog(this);
    eraseCursor = QCursor(QPixmap(":/erase.png"));
    brushCursor = QCursor(QPixmap(":/plain.png"));
    this->resize(400,600);
}

void MainWindow::keyPressEvent(QKeyEvent *e) {
    switch (e->key()) {
    case Qt::Key_F1:
        dbox->open();
        break;
    case Qt::Key_F2:
        std::cerr << "F2 pressed\n";
        setCursor(brushCursor);
        break;
    case Qt::Key_F3:
        std::cerr << "F3 pressed\n";
        setCursor(eraseCursor);
        break;
    }
}

MainWindow::~MainWindow() {}
/**********************************************************/

int main(int argc, char *argv[]) {
    QApplication a(argc, argv);
    MainWindow w;
    w.show();
    return a.exec();
}
