/*
 * Decompiled with CFR 0.152.
 */
package stacey.util;

import beast.core.Description;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.evolution.tree.TreeInterface;
import java.util.ArrayList;
import java.util.List;
import stacey.util.Bindings;

@Description(value="Important utility class for STACEY, used for logP calculation in PIOMSCoalescentDistribution. It connects gene tree nodes to SMC-tree nodes and branches.")
public class FitsHeights {
    private ArrayList<ArrayList<ArrayList<Double>>> heights;
    private Bindings bindings;
    private int currentGTreeIndex;
    private TreeInterface sTree;
    private List<Tree> gTrees;

    public FitsHeights(TreeInterface sTree, List<Tree> gTrees, Bindings bindings) {
        this.bindings = bindings;
        this.sTree = sTree;
        this.gTrees = gTrees;
        this.initHeightArray(sTree, gTrees);
    }

    public boolean updateFitHeightsForOneGTree(int j) {
        this.currentGTreeIndex = j;
        for (ArrayList<ArrayList<Double>> hostNodeHeights : this.heights) {
            hostNodeHeights.get(j).clear();
        }
        Node node = this.makeHeightsSubtree(this.gTrees.get(j).getRoot());
        return node != null;
    }

    public ArrayList<Double> getHeightsFromSNodeNrGTree(int n, int j) {
        return this.heights.get(n).get(j);
    }

    private void initHeightArray(TreeInterface sTree, List<Tree> gTrees) {
        int numSNodes = sTree.getNodeCount();
        int numGTrees = gTrees.size();
        this.heights = new ArrayList(numSNodes);
        for (int n = 0; n < numSNodes; ++n) {
            this.heights.add(new ArrayList(numGTrees));
            for (int j = 0; j < numGTrees; ++j) {
                this.heights.get(n).add(new ArrayList(0));
            }
        }
    }

    private Node makeHeightsSubtree(Node hereG) {
        Node rgtS;
        Node lftS;
        Node lftG = hereG.getChild(0);
        if (lftG.isLeaf()) {
            lftS = this.sTree.getNode(this.bindings.smcTipNrFromGTreeTipNr(this.currentGTreeIndex, lftG.getNr()));
        } else {
            lftS = this.makeHeightsSubtree(lftG);
            if (lftS == null) {
                return null;
            }
        }
        Node rgtG = hereG.getChild(1);
        if (rgtG.isLeaf()) {
            rgtS = this.sTree.getNode(this.bindings.smcTipNrFromGTreeTipNr(this.currentGTreeIndex, rgtG.getNr()));
        } else {
            rgtS = this.makeHeightsSubtree(rgtG);
            if (rgtS == null) {
                return null;
            }
        }
        while (lftS != rgtS) {
            if (lftS.getHeight() < rgtS.getHeight()) {
                lftS = lftS.getParent();
                continue;
            }
            rgtS = rgtS.getParent();
        }
        Node hereS = lftS;
        double heightG = hereG.getHeight();
        if (hereS.getHeight() > heightG) {
            return null;
        }
        Node hostS = hereS;
        while (!hostS.isRoot() && hostS.getParent().getHeight() < heightG) {
            hostS = hostS.getParent();
        }
        this.heights.get(hostS.getNr()).get(this.currentGTreeIndex).add(heightG);
        return hereS;
    }
}

