/*
 * Decompiled with CFR 0.152.
 */
package stacey.util;

import beast.core.Description;

@Description(value="Low-level utility class for STACEY. <br/>")
public class BitUnion {
    private final long[] bits;
    private final int size;

    public BitUnion(int size) {
        int n = (size + 63) / 64;
        this.bits = new long[n];
        for (int b = 0; b < this.bits.length; ++b) {
            this.bits[b] = 0L;
        }
        this.size = size;
    }

    public void replaceWith(BitUnion x) {
        assert (this.size == x.size);
        System.arraycopy(x.bits, 0, this.bits, 0, this.bits.length);
    }

    public void reset() {
        for (int b = 0; b < this.bits.length; ++b) {
            this.bits[b] = 0L;
        }
    }

    public void insert(int i) {
        assert (0 <= i && i < this.size);
        int n = i / 64;
        this.bits[n] = this.bits[n] | 1L << i % 64;
    }

    public boolean isContainedIn(BitUnion x) {
        assert (this.size == x.size);
        for (int b = 0; b < this.bits.length; ++b) {
            if ((this.bits[b] & (x.bits[b] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean overlaps(BitUnion x) {
        assert (this.size == x.size);
        for (int b = 0; b < this.bits.length; ++b) {
            if ((this.bits[b] & x.bits[b]) == 0L) continue;
            return true;
        }
        return false;
    }

    public void union(BitUnion x) {
        assert (this.size == x.size);
        for (int b = 0; b < this.bits.length; ++b) {
            int n = b;
            this.bits[n] = this.bits[n] | x.bits[b];
        }
    }

    public String asText() {
        StringBuilder rep = new StringBuilder();
        rep.append("{");
        for (int b = 0; b < this.size; ++b) {
            String comma = b == 0 ? "" : ",";
            BitUnion x = new BitUnion(this.size);
            x.insert(b);
            if (x.isContainedIn(this)) {
                rep.append(comma).append(b);
                continue;
            }
            rep.append(comma).append(" ");
            if (b > 9) {
                rep.append(" ");
            }
            if (b <= 99) continue;
            rep.append(" ");
        }
        rep.append("}");
        return rep.toString();
    }

    public String toString() {
        return this.asText();
    }

    public int debugNumberBitsSets() {
        int n = 0;
        for (int b = 0; b < this.size; ++b) {
            if ((this.bits[b / 64] & 1L << b % 64) == 0L) continue;
            ++n;
        }
        return n;
    }

    public boolean debugBitIsSet(int b) {
        return (this.bits[b / 64] & 1L << b % 64) != 0L;
    }

    public int debugSize() {
        return this.size;
    }
}

