/*
 * Decompiled with CFR 0.152.
 */
package stacey.debugtune;

import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.evolution.tree.TreeInterface;
import java.util.List;
import stacey.util.Bindings;
import stacey.util.BitUnion;
import stacey.util.Misc;
import stacey.util.UnionArrays;

public class Checks {
    public static void allTreesAndCompatibility(TreeInterface sTree, List<Tree> gTrees, String opName, String when) {
        if (!Checks.treeIsOK(sTree)) {
            System.err.println("BUG found in " + opName + ". Bad sTree " + when);
            System.err.println(Misc.allTreesAsText(sTree, gTrees));
            throw new RuntimeException("Fatal STACEY error.");
        }
        for (TreeInterface treeInterface : gTrees) {
            if (Checks.treeIsOK(treeInterface)) continue;
            System.err.println("BUG found in " + opName + ". Bad gTree " + when);
            System.err.println(Misc.allTreesAsText(sTree, gTrees));
            throw new RuntimeException("Fatal STACEY error.");
        }
        if (!Checks.compatible(sTree, gTrees)) {
            System.err.println("BUG found in " + opName + ". Incompatible trees " + when);
            System.err.println(Misc.allTreesAsText(sTree, gTrees));
            throw new RuntimeException("Fatal STACEY error.");
        }
    }

    public static boolean allTreesAreOKAndCompatible(TreeInterface sTree, List<Tree> gTrees) {
        if (!Checks.treeIsOK(sTree)) {
            return false;
        }
        for (TreeInterface treeInterface : gTrees) {
            if (Checks.treeIsOK(treeInterface)) continue;
            return false;
        }
        return Checks.compatible(sTree, gTrees);
    }

    public static boolean treeIsOK(TreeInterface tree) {
        int n;
        Node[] nodes = tree.getNodesAsArray();
        for (n = 0; n < nodes.length; ++n) {
            if (!Double.isFinite(nodes[n].getHeight())) {
                return false;
            }
            if (!(nodes[n].getHeight() < 0.0)) continue;
            return false;
        }
        for (n = 0; n < nodes.length; ++n) {
            if (nodes[n].isLeaf()) continue;
            if (nodes[n].getChildCount() != 2) {
                return false;
            }
            double nodeHeight = nodes[n].getHeight();
            if (nodes[n].getChild(0).getHeight() > nodeHeight) {
                return false;
            }
            if (!(nodes[n].getChild(1).getHeight() > nodeHeight)) continue;
            return false;
        }
        return true;
    }

    public static boolean compatible(TreeInterface sTree, List<Tree> gTrees) {
        Bindings bindings = Bindings.initialise(sTree, gTrees);
        UnionArrays unionArrays = UnionArrays.initialise(sTree, gTrees, bindings);
        unionArrays.update();
        if (!Checks.allUnionsLookOK(sTree, gTrees, unionArrays)) {
            return false;
        }
        for (int j = 0; j < gTrees.size(); ++j) {
            TreeInterface gTree = (TreeInterface)gTrees.get(j);
            for (int i = 0; i < gTree.getNodeCount(); ++i) {
                BitUnion gUnion = unionArrays.gNodeUnion(j, i);
                double gHeight = gTree.getNode(i).getHeight();
                int n = unionArrays.smcTreeNodeNrOfUnion(gUnion);
                if (!(sTree.getNode(n).getHeight() > gHeight)) continue;
                return false;
            }
        }
        unionArrays.reset();
        return true;
    }

    private static boolean allUnionsLookOK(TreeInterface sTree, List<Tree> gTrees, UnionArrays unionArrays) {
        BitUnion[] sUnions = new BitUnion[sTree.getNodeCount()];
        for (int n = 0; n < sTree.getNodeCount(); ++n) {
            sUnions[n] = unionArrays.sNodeUnion(n);
        }
        if (!Checks.unionsLookOK(sTree, sUnions)) {
            return false;
        }
        for (int j = 0; j < gTrees.size(); ++j) {
            TreeInterface gTree = (TreeInterface)gTrees.get(j);
            BitUnion[] gUnions = new BitUnion[gTree.getNodeCount()];
            for (int i = 0; i < gTree.getNodeCount(); ++i) {
                gUnions[i] = unionArrays.gNodeUnion(j, i);
            }
            if (Checks.unionsLookOK(gTree, gUnions)) continue;
            return false;
        }
        return true;
    }

    private static boolean unionsLookOK(TreeInterface tree, BitUnion[] unions) {
        for (int n = 0; n < tree.getNodeCount(); ++n) {
            BitUnion hereU;
            Node node = tree.getNode(n);
            if (node.isLeaf()) {
                hereU = unions[node.getNr()];
                if (hereU.debugNumberBitsSets() != 1) {
                    return false;
                }
            } else {
                hereU = unions[node.getNr()];
                BitUnion lftU = unions[node.getChild(0).getNr()];
                BitUnion rgtU = unions[node.getChild(1).getNr()];
                int size = hereU.debugSize();
                for (int b = 0; b < size; ++b) {
                    boolean rgt;
                    boolean here = hereU.debugBitIsSet(b);
                    boolean lft = lftU.debugBitIsSet(b);
                    if ((lft | (rgt = rgtU.debugBitIsSet(b))) == here) continue;
                    return false;
                }
            }
            if (!node.isRoot() || (hereU = unions[node.getNr()]).debugNumberBitsSets() == hereU.debugSize()) continue;
            return false;
        }
        return true;
    }
}

