/*
 * Decompiled with CFR 0.152.
 */
package stacey;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.core.Loggable;
import beast.core.parameter.RealParameter;
import beast.util.Randomizer;
import java.io.PrintStream;
import stacey.PIOMSCoalescentDistribution;
import stacey.util.InverseGammaMixture;

@Description(value="Statistic that samples the the overall population scale factor multiplied by the per-branch inverse gamma mixture.")
public class PopSampleStatistic
extends BEASTObject
implements Loggable {
    public Input<RealParameter> popPriorScaleInput = new Input("popPriorScale", "Overall scale for population size", Input.Validate.REQUIRED);
    public Input<PIOMSCoalescentDistribution> piomscdInput = new Input("piomsCoalDist", "The PIOMSCoalescentDistribution", Input.Validate.REQUIRED);

    public void initAndValidate() {
    }

    public void init(PrintStream out) {
        out.print("PopSize\t");
    }

    public void log(long nSample, PrintStream out) {
        out.print("" + this.getStatisticValue() + "\t");
    }

    public void close(PrintStream out) {
    }

    private double getStatisticValue() {
        InverseGammaMixture igm = ((PIOMSCoalescentDistribution)((Object)this.piomscdInput.get())).getInverseGammaMixture();
        double[] a = igm.getAlphas();
        double[] b = igm.getBetas();
        int i = Randomizer.randomChoicePDF((double[])igm.getWeights());
        double x = Randomizer.nextGamma((double)a[i], (double)b[i]);
        return ((RealParameter)this.popPriorScaleInput.get()).getValue() / x;
    }
}

