/*
 * Decompiled with CFR 0.152.
 */
package stacey;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.core.StateNode;
import beast.core.parameter.RealParameter;

@Description(value="A component in a mixture of inverse gamma distributions.")
public class InverseGammaComponent
extends BEASTObject {
    public Input<RealParameter> weight = new Input("weight", "weight of component in mixture of inverse gammas", Input.Validate.REQUIRED);
    public Input<RealParameter> alpha = new Input("alpha", "shape parameter of an inverse gamma", Input.Validate.REQUIRED);
    public Input<RealParameter> beta = new Input("beta", "scale parameter of an inverse gamma", Input.Validate.REQUIRED);

    public void initAndValidate() {
        if (this.getWeight() <= 0.0) {
            throw new IllegalArgumentException("weight must be positive");
        }
        if (this.getAlpha() <= 0.0) {
            throw new IllegalArgumentException("alpha must be positive");
        }
        if (this.getBeta() <= 0.0) {
            throw new IllegalArgumentException("beta must be positive");
        }
    }

    double getWeight() {
        return ((RealParameter)this.weight.get()).getValue();
    }

    double getAlpha() {
        return ((RealParameter)this.alpha.get()).getValue();
    }

    double getBeta() {
        return ((RealParameter)this.beta.get()).getValue();
    }

    void normalizeWeight(double total) {
        Double[] normWt = new Double[]{((RealParameter)this.weight.get()).getValue() / total};
        RealParameter normalizedWeight = new RealParameter(normWt);
        ((RealParameter)this.weight.get()).assignFromWithoutID((StateNode)normalizedWeight);
    }
}

