/*
 * Decompiled with CFR 0.152.
 */
package stacey;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.core.Loggable;
import beast.evolution.tree.Node;
import beast.evolution.tree.TreeInterface;
import java.io.PrintStream;
import java.util.List;
import stacey.BirthDeathCollapseModel;

@Description(value="Statistic that counts the number of clusters (equals one more than the number of collapsed nodes)")
public class BirthDeathCollapseNClustersStatistic
extends BEASTObject
implements Loggable {
    public Input<TreeInterface> smcTree = new Input("smcTree", "Species or minimal clusters  tree", Input.Validate.REQUIRED);
    public Input<BirthDeathCollapseModel> bdcm = new Input("bdcm", "The birth death collapse model", Input.Validate.REQUIRED);

    public void initAndValidate() {
    }

    public void init(PrintStream out) {
        out.print("NClusters\t");
    }

    public void log(long nSample, PrintStream out) {
        out.print("" + this.getStatisticValue() + "\t");
    }

    public void close(PrintStream out) {
    }

    private double getStatisticValue() {
        List inodes = ((TreeInterface)this.smcTree.get()).getInternalNodes();
        int n = 0;
        for (Node node : inodes) {
            double h = node.getHeight();
            if (BirthDeathCollapseModel.belowCollapseHeight(h)) continue;
            ++n;
        }
        return n + 1;
    }
}

