/*
 * Decompiled with CFR 0.152.
 */
package stacey;

import beast.core.Citation;
import beast.core.Description;
import beast.core.Input;
import beast.core.StateNode;
import beast.core.parameter.RealParameter;
import beast.evolution.speciation.SpeciesTreeDistribution;
import beast.evolution.tree.Node;
import beast.evolution.tree.TreeInterface;
import java.util.List;

@Description(value="Birth-death-collapse distribution of prior for species tree or minimal clusters tree.")
@Citation(value="Jones GR, Aydin Z, and Oxelman B (2015). DISSECT: an assignment-free Bayesian discovery method for species delimitation under the multispecies coalescent.\nBioinformatics 31 (7) 991-998. DOI 10.1101/003178\nhttp://bioinformatics.oxfordjournals.org/content/31/7/991.", firstAuthorSurname="Jones")
public class BirthDeathCollapseModel
extends SpeciesTreeDistribution {
    public static final Input<Double> collapseHeight = new Input("collapseHeight", "Collapse height value, epsilon in birth/death/collapse model.", Input.Validate.REQUIRED);
    public Input<RealParameter> birthDiffRate = new Input("birthDiffRate", "Growth rate rate parameter, lambda-mu in birth/death/collapse model.", Input.Validate.REQUIRED);
    public Input<RealParameter> relativeDeathRate = new Input("relativeDeathRate", "Relative death rate parameter, mu/lambda in birth/death/collapse model.", Input.Validate.REQUIRED);
    public Input<RealParameter> collapseWeight = new Input("collapseWeight", "Collapse weight parameter, w in birth/death/collapse model.", Input.Validate.REQUIRED);
    public Input<RealParameter> originHeight = new Input("originHeight", "Origin height of the species-or-minimal-clusters tree. Must be estimated. Initial value is ignored. In birth/death/collapse model", Input.Validate.REQUIRED);

    public void initAndValidate() {
        super.initAndValidate();
        if ((Double)collapseHeight.get() < 1.0E-30 || (Double)collapseHeight.get() > 1.0E10) {
            throw new IllegalArgumentException("Bad collapseHeight value");
        }
        TreeInterface tree = (TreeInterface)this.treeInput.get();
        Double[] initOHarray = new Double[]{1.05 * tree.getRoot().getHeight()};
        RealParameter initOH = new RealParameter(initOHarray);
        ((RealParameter)this.originHeight.get()).assignFromWithoutID((StateNode)initOH);
    }

    public double calculateTreeLogLikelihood(TreeInterface tree) {
        this.logP = this.treeLL(tree);
        return this.logP;
    }

    private double treeLL(TreeInterface tree) {
        double logpt = 0.0;
        int ntips = tree.getLeafNodeCount();
        double alpha = ((RealParameter)this.birthDiffRate.get()).getValue();
        double beta = ((RealParameter)this.relativeDeathRate.get()).getValue();
        double tor = ((RealParameter)this.originHeight.get()).getValue();
        double w = ((RealParameter)this.collapseWeight.get()).getValue();
        double rooth = tree.getRoot().getHeight();
        if (rooth > tor) {
            return Double.NEGATIVE_INFINITY;
        }
        logpt += this.originHeightLogLikelihood(tor, alpha, beta, w, ntips);
        List internalNodes = tree.getInternalNodes();
        for (Node node : internalNodes) {
            double height = node.getHeight();
            double usualpn = this.nodeHeightLikelihood(height, tor, alpha, beta);
            double collapsedpn = BirthDeathCollapseModel.belowCollapseHeight(height) ? 1.0 / (Double)collapseHeight.get() : 0.0;
            logpt += Math.log((1.0 - w) * usualpn + w * collapsedpn);
        }
        return logpt;
    }

    static boolean belowCollapseHeight(double h) {
        return h < (Double)collapseHeight.get();
    }

    public static double collapseHeight() {
        return (Double)collapseHeight.get();
    }

    private double originHeightLogLikelihood(double t, double a, double b, double w, int n) {
        double E = Math.exp(-a * t);
        double B = (1.0 - E) / (1.0 - b * E);
        double z = 0.0;
        z += Math.log(a);
        z += Math.log(1.0 - b);
        z -= a * t;
        z -= 2.0 * Math.log(1.0 - b * E);
        z += (double)(n - 2) * Math.log(w + (1.0 - w) * B);
        return z += Math.log(w + (double)n * (1.0 - w) * B);
    }

    private double nodeHeightLikelihood(double s, double t, double a, double b) {
        double Es = Math.exp(-a * s);
        double Et = Math.exp(-a * t);
        double z = 0.0;
        if (s < t) {
            z = a;
            z *= 1.0 - b;
            z *= Es;
            z /= (1.0 - b * Es) * (1.0 - b * Es);
            z *= 1.0 - b * Et;
            z /= 1.0 - Et;
        }
        return z;
    }

    protected boolean requiresRecalculation() {
        return super.requiresRecalculation() || ((RealParameter)this.birthDiffRate.get()).somethingIsDirty() || ((RealParameter)this.relativeDeathRate.get()).somethingIsDirty() || ((RealParameter)this.collapseWeight.get()).somethingIsDirty() || ((RealParameter)this.originHeight.get()).somethingIsDirty();
    }
}

