/*
 * Decompiled with CFR 0.152.
 */
package stacey.util;

import beast.core.Description;
import java.util.Arrays;

@Description(value="Utility class for STACEY which implements a mixture of inverse gamma distributions.")
public class InverseGammaMixture {
    private final double[] weights;
    private final double[] alphas;
    private final double[] betas;

    public InverseGammaMixture(int ncs) {
        this.weights = new double[ncs];
        this.alphas = new double[ncs];
        this.betas = new double[ncs];
    }

    public void setWeight(int c, double weight) {
        this.weights[c] = weight;
    }

    public void setAlpha(int c, double alpha) {
        this.alphas[c] = alpha;
    }

    public void setBeta(int c, double beta) {
        this.betas[c] = beta;
    }

    public double[] getWeights() {
        return Arrays.copyOf(this.weights, this.weights.length);
    }

    public double[] getAlphas() {
        return Arrays.copyOf(this.alphas, this.alphas.length);
    }

    public double[] getBetas() {
        return Arrays.copyOf(this.betas, this.betas.length);
    }

    public double middlingValue() {
        double mv = 0.0;
        for (int i = 0; i < this.weights.length; ++i) {
            mv += this.weights[i] * this.betas[i] / this.alphas[i];
        }
        return mv;
    }
}

