/*
 * Decompiled with CFR 0.152.
 */
package stacey.util;

import beast.core.Description;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.Taxon;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.evolution.tree.TreeInterface;
import java.util.List;
import stacey.util.BitUnion;

@Description(value="Provides various linkages between the SMC-Tree tips and gene tree tips.")
public class Bindings {
    private final BitUnion[] smcTipUnions;
    private final BitUnion[][] gTipNrToUnion;
    private final int[][] gTipNrToSmcTipNr;
    private final int[][] nLinsForSmcTipNr;
    private static volatile Bindings bindings = null;

    public static Bindings initialise(TreeInterface sTree, List<Tree> gTrees) {
        if (bindings == null) {
            bindings = new Bindings(sTree, gTrees);
        }
        return bindings;
    }

    public int smcTipNrFromGTreeTipNr(int j, int gTipNr) {
        return this.gTipNrToSmcTipNr[j][gTipNr];
    }

    public int nLineagesForBeastTipNrAndGtree(int beastNodeNr, int j) {
        return this.nLinsForSmcTipNr[beastNodeNr][j];
    }

    public int smcTreeTipCount() {
        return this.smcTipUnions.length;
    }

    public BitUnion tipUnionOfSMCNodeNr(int nodeNr) {
        return this.smcTipUnions[nodeNr];
    }

    public BitUnion tipUnionOfGNodeNr(int j, int nodeNr) {
        return this.gTipNrToUnion[j][nodeNr];
    }

    private Bindings(TreeInterface sTree, List<Tree> gTrees) {
        int nSTips = sTree.getLeafNodeCount();
        int nGTrees = gTrees.size();
        this.smcTipUnions = new BitUnion[nSTips];
        for (int i = 0; i < nSTips; ++i) {
            this.smcTipUnions[i] = new BitUnion(nSTips);
            this.smcTipUnions[i].insert(i);
        }
        this.gTipNrToUnion = new BitUnion[nGTrees][];
        this.gTipNrToSmcTipNr = new int[nGTrees][];
        this.nLinsForSmcTipNr = new int[nSTips][nGTrees];
        this.setUpTipMaps(sTree, gTrees);
        this.setUpTipNlineages(sTree, gTrees);
        this.checkAllNlineagesNonZero(sTree, gTrees);
    }

    private void setUpTipNlineages(TreeInterface sTree, List<Tree> gTrees) {
        int nSTips = sTree.getLeafNodeCount();
        int nGTrees = gTrees.size();
        for (int STipNr = 0; STipNr < nSTips; ++STipNr) {
            for (int j = 0; j < nGTrees; ++j) {
                int nlins = 0;
                for (int GTipNr = 0; GTipNr < this.gTipNrToUnion[j].length; ++GTipNr) {
                    if (this.gTipNrToSmcTipNr[j][GTipNr] != STipNr) continue;
                    ++nlins;
                }
                this.nLinsForSmcTipNr[STipNr][j] = nlins;
            }
        }
    }

    private void checkAllNlineagesNonZero(TreeInterface sTree, List<Tree> gTrees) {
        for (int STipNr = 0; STipNr < this.nLinsForSmcTipNr.length; ++STipNr) {
            for (int j = 0; j < this.nLinsForSmcTipNr[STipNr].length; ++j) {
                if (this.nLinsForSmcTipNr[STipNr][j] > 0) continue;
                System.err.println("A species/minimal cluster has no sequences for at least one locus.");
                String sTipID = sTree.getNode(STipNr).getID();
                String alignmentID = null;
                alignmentID = ((Alignment)gTrees.get((int)j).getTaxonset().alignmentInput.get()).getID();
                System.err.println("Species/minimal cluster '" + sTipID + "' has no sequences in alignment '" + alignmentID + "'.");
                throw new RuntimeException("Fatal STACEY error.");
            }
        }
    }

    private void setUpTipMaps(TreeInterface sTree, List<Tree> gTrees) {
        for (int j = 0; j < gTrees.size(); ++j) {
            TreeInterface gTree = (TreeInterface)gTrees.get(j);
            List gTips = gTree.getExternalNodes();
            int nGTips = gTips.size();
            this.gTipNrToUnion[j] = new BitUnion[nGTips];
            this.gTipNrToSmcTipNr[j] = new int[nGTips];
            for (int i = 0; i < nGTips; ++i) {
                int smcTipNr;
                int beastNr = ((Node)gTips.get(i)).getNr();
                assert (i == beastNr);
                String gtName = ((Node)gTips.get(i)).getID();
                this.gTipNrToSmcTipNr[j][beastNr] = smcTipNr = this.smcTipNrFromGTipID(sTree, gtName);
                this.gTipNrToUnion[j][beastNr] = new BitUnion(sTree.getLeafNodeCount());
                this.gTipNrToUnion[j][beastNr].insert(smcTipNr);
            }
        }
    }

    private int smcTipNrFromGTipID(TreeInterface sTree, String gTipID) {
        String smcTipID = this.smcTipIDFromGTipID(sTree.getTaxonset(), gTipID);
        List sTips = sTree.getExternalNodes();
        int tipNr = -1;
        for (Node sTip : sTips) {
            if (sTip.getID().compareTo(smcTipID) != 0) continue;
            if (tipNr != -1) {
                System.err.println("Error in smcTipNrFromGTipID() with taxon '" + gTipID + "'.\nAssigned twice to SMC-tree tip number " + tipNr + ".");
                throw new RuntimeException("Fatal STACEY error.");
            }
            assert (tipNr == -1);
            tipNr = sTip.getNr();
        }
        if (tipNr < 0) {
            System.err.println("Error in smcTipNrFromGTipID() with taxon '" + gTipID + "'.\nCan't assign to SMC-tree tip number " + tipNr + ".");
            System.err.println("Have you used the same label for a minimal cluster and an individual?");
            throw new RuntimeException("Fatal STACEY error.");
        }
        assert (tipNr >= 0);
        return tipNr;
    }

    private String smcTipIDFromGTipID(TaxonSet taxonSetOfSets, String gTipID) {
        String smcTipID = "";
        for (int sts = 0; sts < taxonSetOfSets.getTaxonCount(); ++sts) {
            TaxonSet smc = (TaxonSet)((List)taxonSetOfSets.taxonsetInput.get()).get(sts);
            for (int gt = 0; gt < smc.getTaxonCount(); ++gt) {
                String sgID = ((Taxon)((List)smc.taxonsetInput.get()).get(gt)).getID();
                if (gTipID.compareTo(sgID) != 0) continue;
                if (smcTipID.compareTo("") != 0) {
                    System.err.println("Error in smcTipIDFromGTipID() with taxon '" + gTipID + "'.\nAssigned twice to SMC-tree tip '" + smcTipID + "'.");
                    throw new RuntimeException("Fatal STACEY error.");
                }
                assert (smcTipID.compareTo("") == 0);
                smcTipID = smc.getID();
            }
        }
        if (smcTipID.compareTo("") == 0) {
            System.err.println("Error in smcTipIDFromGTipID() with taxon '" + gTipID + "'.\nCan't assign to SMC-tree tip '" + smcTipID + "'.");
            throw new RuntimeException("Fatal STACEY error.");
        }
        assert (smcTipID.compareTo("") != 0);
        return smcTipID;
    }
}

