/*
 * Decompiled with CFR 0.152.
 */
package stacey;

import beast.core.Description;
import beast.core.Input;
import beast.core.Operator;
import beast.core.parameter.RealParameter;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.evolution.tree.TreeInterface;
import beast.util.Randomizer;
import java.util.ArrayList;
import java.util.List;
import stacey.debugtune.Checks;
import stacey.util.Bindings;
import stacey.util.BitUnion;
import stacey.util.UnionArrays;

@Description(value="Faster implementation of BEAST's NodeReheight move. It implements the method of Newton, Mau, and Larget (1999) on the SMC-tree while maintaining compatibility with gene trees.")
public class StaceyNodeReheight
extends Operator {
    public Input<Tree> smcTreeInput = new Input("smcTree", "The species tree or minimal clusters tree", Input.Validate.REQUIRED);
    public Input<List<Tree>> geneTreesInput = new Input("geneTree", "All gene trees", new ArrayList());
    public Input<RealParameter> popSFInput = new Input("popSF", "The population scaling factor for the STACEY coalescent", Input.Validate.REQUIRED);
    public Input<Double> propUniformInput = new Input("proportionUniform", "The fraction of times which the operator uses a uniform density for sampling new heights. It must be between 0.0 and 1.0. The rest of the time the operator uses a density skewed towards the maximum compatible height.");
    public Input<Double> tuningInput = new Input("tuning", "A tuning parameter. The default is 1.0, and allowed values are positive numbers. Larger values make bigger jumps and so decrease the acceptance ratio. Experiments in the range [0.1,10.0] seem sensible.");
    public Input<Long> delayInput = new Input("delay", "Number of times the operator is disabled.");
    private Tree sTree;
    private List<Tree> gTrees;
    private int callCount = 0;
    private boolean sTreeTooSmall;
    private UnionArrays unionArrays;
    private double propUniform = 0.1;
    private double tuning = 1.0;
    private long delay = 0L;
    private final boolean debugFlag = Boolean.valueOf(System.getProperty("stacey.debug"));
    private int numberofdebugchecks = 0;
    private static final int maxnumberofdebugchecks = 100000;

    public void initAndValidate() {
        this.sTree = (Tree)this.smcTreeInput.get();
        this.gTrees = (List)this.geneTreesInput.get();
        boolean bl = this.sTreeTooSmall = this.sTree.getLeafNodeCount() < 3;
        if (this.delayInput != null && this.delayInput.get() != null) {
            this.delay = (Long)this.delayInput.get();
        }
        this.propUniform = 0.1;
        if (this.propUniformInput != null && this.propUniformInput.get() != null) {
            this.propUniform = (Double)this.propUniformInput.get();
        }
        Bindings bindings = Bindings.initialise((TreeInterface)this.sTree, this.gTrees);
        this.unionArrays = UnionArrays.initialise((TreeInterface)this.sTree, this.gTrees, bindings);
    }

    public double proposal() {
        if (this.sTreeTooSmall) {
            return Double.NEGATIVE_INFINITY;
        }
        ++this.callCount;
        if ((long)this.callCount < this.delay) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.debugFlag && this.numberofdebugchecks < 100000) {
            Checks.allTreesAndCompatibility((TreeInterface)this.sTree, this.gTrees, "StaceyNodeReheight", "before move");
            ++this.numberofdebugchecks;
        }
        this.unionArrays.update();
        double logHR = this.doNodeReheightMove();
        this.unionArrays.reset();
        if (this.debugFlag && this.numberofdebugchecks < 100000) {
            Checks.allTreesAndCompatibility((TreeInterface)this.sTree, this.gTrees, "StaceyNodeReheight", "after move");
            ++this.numberofdebugchecks;
        }
        return logHR;
    }

    private double doNodeReheightMove() {
        double logHR;
        double newHeight;
        Node[] sNodes = this.sTree.getNodesAsArray();
        this.sTree.startEditing((Operator)this);
        this.reorder(this.sTree.getRoot());
        double[] fHeights = new double[sNodes.length];
        int[] iReverseOrder = new int[sNodes.length];
        this.collectHeights(this.sTree.getRoot(), fHeights, iReverseOrder, 0);
        int iNode = Randomizer.nextInt((int)fHeights.length);
        while (this.sTree.getNodesAsArray()[iReverseOrder[iNode]].isLeaf()) {
            iNode = Randomizer.nextInt((int)fHeights.length);
        }
        double maxHeight = this.calcMaxHeight(iReverseOrder, iNode);
        if (Randomizer.nextDouble() > this.propUniform) {
            double popSF = ((RealParameter)this.popSFInput.get()).getValue();
            if (this.tuningInput != null && this.tuningInput.get() != null) {
                this.tuning = (Double)this.tuningInput.get();
            }
            double hgtOffset = this.tuning * 0.1 * popSF / (double)this.gTrees.size();
            double oldHeight = fHeights[iNode];
            newHeight = this.newHeightSample(maxHeight, hgtOffset);
            double oldDensity = this.newHeightPDF(oldHeight, maxHeight, hgtOffset);
            double newDensity = this.newHeightPDF(newHeight, maxHeight, hgtOffset);
            logHR = Math.log(oldDensity / newDensity);
        } else {
            newHeight = Randomizer.nextDouble() * maxHeight;
            logHR = 0.0;
        }
        fHeights[iNode] = newHeight;
        sNodes[iReverseOrder[iNode]].setHeight(fHeights[iNode]);
        Node root = this.reconstructTree(fHeights, iReverseOrder, 0, fHeights.length, new boolean[fHeights.length]);
        assert (this.checkConsistency(root, new boolean[fHeights.length]));
        root.setParent(null);
        this.sTree.setRoot(root);
        return logHR;
    }

    private double newHeightPDF(double x, double h, double a) {
        double d = 1.0 / (Math.log(h + a) - Math.log(a));
        return d /= h + a - x;
    }

    private double newHeightSample(double h, double a) {
        double y = Randomizer.nextDouble();
        double q = h + a - Math.exp(Math.log(h + a) * (1.0 - y) + Math.log(a) * y);
        q = Math.max(q, 0.0);
        q = Math.min(q, h);
        return q;
    }

    private boolean checkConsistency(Node node, boolean[] bUsed) {
        if (bUsed[node.getNr()]) {
            return false;
        }
        bUsed[node.getNr()] = true;
        if (node.isLeaf()) {
            return true;
        }
        return this.checkConsistency(node.getLeft(), bUsed) && this.checkConsistency(node.getRight(), bUsed);
    }

    private double calcMaxHeight(int[] iReverseOrder, int iNode) {
        BitUnion sppL = new BitUnion(this.sTree.getLeafNodeCount());
        Node[] nodes = this.sTree.getNodesAsArray();
        for (int i = 0; i < iNode; ++i) {
            Node node = nodes[iReverseOrder[i]];
            if (!node.isLeaf()) continue;
            sppL.insert(node.getNr());
        }
        BitUnion sppR = new BitUnion(this.sTree.getLeafNodeCount());
        for (int i = iNode + 1; i < nodes.length; ++i) {
            Node node = nodes[iReverseOrder[i]];
            if (!node.isLeaf()) continue;
            sppR.insert(node.getNr());
        }
        double maxHeight = Double.POSITIVE_INFINITY;
        for (int j = 0; j < this.gTrees.size(); ++j) {
            ArrayList<Node> straddlers = this.unionArrays.getStraddlers(j, sppL, sppR);
            for (Node straddler : straddlers) {
                maxHeight = Math.min(maxHeight, straddler.getHeight());
            }
        }
        return maxHeight;
    }

    private Node reconstructTree(double[] fHeights, int[] iReverseOrder, int iFrom, int iTo, boolean[] bHasParent) {
        Node[] sNodes = this.sTree.getNodesAsArray();
        int iNode = -1;
        double fMax = Double.NEGATIVE_INFINITY;
        for (int j = iFrom; j < iTo; ++j) {
            if (!(fMax < fHeights[j]) || sNodes[iReverseOrder[j]].isLeaf()) continue;
            fMax = fHeights[j];
            iNode = j;
        }
        if (iNode < 0) {
            return null;
        }
        Node node = sNodes[iReverseOrder[iNode]];
        int iLeft = -1;
        fMax = Double.NEGATIVE_INFINITY;
        for (int j = iFrom; j < iNode; ++j) {
            if (!(fMax < fHeights[j]) || bHasParent[j]) continue;
            fMax = fHeights[j];
            iLeft = j;
        }
        int iRight = -1;
        fMax = Double.NEGATIVE_INFINITY;
        for (int j = iNode + 1; j < iTo; ++j) {
            if (!(fMax < fHeights[j]) || bHasParent[j]) continue;
            fMax = fHeights[j];
            iRight = j;
        }
        node.setLeft(sNodes[iReverseOrder[iLeft]]);
        node.getLeft().setParent(node);
        node.setRight(sNodes[iReverseOrder[iRight]]);
        node.getRight().setParent(node);
        if (node.getLeft().isLeaf()) {
            fHeights[iLeft] = Double.NEGATIVE_INFINITY;
        }
        if (node.getRight().isLeaf()) {
            fHeights[iRight] = Double.NEGATIVE_INFINITY;
        }
        bHasParent[iLeft] = true;
        bHasParent[iRight] = true;
        fHeights[iNode] = Double.NEGATIVE_INFINITY;
        this.reconstructTree(fHeights, iReverseOrder, iFrom, iNode, bHasParent);
        this.reconstructTree(fHeights, iReverseOrder, iNode, iTo, bHasParent);
        return node;
    }

    private int collectHeights(Node node, double[] fHeights, int[] iReverseOrder, int iCurrent) {
        if (node.isLeaf()) {
            fHeights[iCurrent] = node.getHeight();
            iReverseOrder[iCurrent] = node.getNr();
            ++iCurrent;
        } else {
            iCurrent = this.collectHeights(node.getLeft(), fHeights, iReverseOrder, iCurrent);
            fHeights[iCurrent] = node.getHeight();
            iReverseOrder[iCurrent] = node.getNr();
            ++iCurrent;
            iCurrent = this.collectHeights(node.getRight(), fHeights, iReverseOrder, iCurrent);
        }
        return iCurrent;
    }

    private void reorder(Node node) {
        if (!node.isLeaf()) {
            if (Randomizer.nextBoolean()) {
                Node tmp = node.getLeft();
                node.setLeft(node.getRight());
                node.setRight(tmp);
            }
            this.reorder(node.getLeft());
            this.reorder(node.getRight());
        }
    }
}

